'use strict';

app.config(['$routeProvider', function($routeProvider) {
    $routeProvider
        .when('/boardControlPanel/personnel', {
            templateUrl: '/partials/front/boardPanel/staff/main.html'
            ,resolve: {
                usersList: BCPPersonnelCtrl.getUsersInGroupForLoggedUser
//                ,company: BCPPersonnelCtrl.getCompanyForLoggedUser
                ,companyRoleTypes: BCPPersonnelCtrl.getCompanyRoleTypes
//                ,employees: BCPPersonnelCtrl.getEmployees
//                ,departments: BCPPersonnelCtrl.getDepartments
                ,CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
            }
        })
        .when('/boardControlPanel/estate', {
            templateUrl: '/partials/front/boardPanel/estate/estate.html'
            ,resolve: {
//                company: BCPEstateCtrl.getCompanyForLoggedUser
                placesList: BCPEstateCtrl.getRandomPlaces
                ,EstatesCurrentList: function(EstatesCurrentList){
                    return EstatesCurrentList.loadData();
                }
                ,CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
            }
        })
        .when('/boardControlPanel/bank', {
            templateUrl: '/partials/front/boardPanel/bank/main.html'
            ,resolve: {
//                company: BCPBankCtrl.getCompanyForLoggedUser
//                bankServices: BCPBankCtrl.getBankServices
                CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
            }
        })
        .when('/boardControlPanel/chattel', {
            templateUrl: '/partials/front/boardPanel/chattel/chattel.html'
            ,resolve: {
                offersList: BCPChattelCtrl.getRandomOffers
                ,srodkiTrwale: function(STCurrentList){
                    return STCurrentList.loadData();
                }
                ,CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
            }
        })
        .when('/boardControlPanel/production', {
            templateUrl: '/partials/front/boardPanel/production.html'
            ,resolve: {
                CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,CompanyInventory: BCPProductionCtrl.getInventory
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
                ,DistributionSalesList: function(DistributionSalesList){
                    return DistributionSalesList.loadData();
                }
            }
        })
        .when('/boardControlPanel/priceList', {
            templateUrl: '/partials/front/boardPanel/priceList.html'
            ,resolve: {
                CompanyNew: function(Company){
                    return Company.loadData();
                }
                ,CompanyDepartments: function(DepartmentsList){
                    return DepartmentsList.loadData();
                }
                ,CompanyBanksList: function(BanksList){
                    return BanksList.loadData();
                }
                ,RandomEmployeesList: function(RandomEmployeesList){
                    return RandomEmployeesList.loadData();
                }
                ,ReportsList: function(ReportsList){
                    return ReportsList.loadData();
                }
                ,Rounds: function(RoundsManager){
                    return RoundsManager.loadData();
                }
                ,OffersList: function(OffersList){
                    return OffersList.loadData();
                }
                ,Currency: function(CurrencyManager){
                    return CurrencyManager.loadData();
                }
            }
        })
        .when('/quotes', {
            templateUrl: '/partials/front/boardPanel/quotes/main.html'
            ,resolve: {
                type: function(){return 'quotes';}
                ,quotes: function(QuotesManager){
                    return QuotesManager.loadGpwTypesList();
                }
            }
        })
        .when('/indicators', {
            templateUrl: '/partials/front/boardPanel/indicators/main.html'
            ,resolve: {
                type: function(){return 'indicators';}
                ,indicators: function(IndicatorsManager){
                    return IndicatorsManager.loadData();
                }
            }
        })
        .otherwise({redirectTo: '/boardControlPanel/personnel'});
}]);

